//
//  PersonMO.m
//  Example
//
//  Created by Amin Negm-Awad on Di,29.07.08.
//  Copyright 2008 Dr. Pribilla Kaldenhoff Negm. All rights reserved.
//

#import "PersonMO.h"


@implementation PersonMO
@dynamic firstName, lastName;

- (NSString*)fullName {
   return [NSString stringWithFormat:@"%@, %@", self.firstName, self.lastName];
}

- (BOOL)validateLastName:(id*)value error:(NSError**)error {
   if( [*value length] < 2 ) {
      NSDictionary* userInfo = [NSDictionary dictionaryWithObject:@"Zu kurz, da beiß die Maus keinen Pfaden ab" 
                                                           forKey:NSLocalizedDescriptionKey];
      *error = [NSError errorWithDomain:@"Application"
                                   code:1 
                               userInfo:userInfo];
      
      return NO;
   } else {
      return YES;
   }
}

+ (NSSet*)keyPathsForValuesAffectingFullName {
   return [NSSet setWithObjects:@"firstName", @"lastName", nil];
}

- (void)logDescription {
   NSLog( @"%@", self );
}
@end
